class Octorok < Enemy
  def initialize(args, info)
    super

    @position.x = info.position.x
    @position.y = info.position.y

    @path = "sprites/enemies/octorok.png"

    @direction = :south
    @last_direction_change_time = args.state.tick_count

    @move_directions = @@VALID_DIRECTIONS.copy
    @walk_frame = 0
    @can_shoot = true
  end

  def tick(args)
    if args.state.tick_count - @last_direction_change_time > 30
      @last_direction_change_time = args.state.tick_count
      @direction = @move_directions.sample
      if (check = rand()) >= 0.0
        @move_directions -= [@direction]
      end
      if @move_directions.empty?
        @move_directions = @@VALID_DIRECTIONS.copy
      end
    end


    rect = args.state.room_rect.copy
    rect.x, rect.y = 0, 0

    if collision_rect.inside_rect?(rect)
      move(@direction)
      @walk_frame = (@walk_frame + 1) % 2
    else
      @direction = opposide_direction(@direction)
      move(@direction)
    end


    shoot_time_diff = args.state.tick_count - @last_shoot_time
    if (shoot_time_diff > 5) && @projectile_obj.nil?
      @last_shoot_time = args.state.tick_count

      pos_offset = @position.copy
      case @direction
      when :north
        pos_offset.x = pos_offset.x + 8
        pos_offset.y = pos_offset.y + @size.h
      when :south
        pos_offset.x = pos_offset.x + 8
      when :east
        pos_offset.x = pos_offset.x + @size.w
        pos_offset.y = pos_offset.y + 8
      when :west
        pos_offset.x = pos_offset.x - 8
      end

      pos_offset.x += args.state.room_offset.x
      pos_offset.y += args.state.room_offset.y
      params = {
        position: pos_offset,
        direction: @direction
      }
      @projectile_obj = Rock.new(args, params)
    end

    room_rect = {x: args.state.room_offset.x - 30, y: args.state.room_offset.x - 30, w: args.state.room_width + 60, h: args.state.room_height + 60}
    if @projectile_obj
      @projectile_obj.tick(args)
      @projectile_obj = nil unless @projectile_obj.collision_rect.inside_rect?(room_rect)
      
      # @projectile_obj = nil if @projectile_obj && @projectile_obj.x > args.state.room_width + 10
      # @projectile_obj = nil if @projectile_obj && @projectile_obj.y > args.state.room_height + 10
      # @projectile_obj = nil if @projectile_obj && @projectile_obj.x < -30
      # @projectile_obj = nil if @projectile_obj && @projectile_obj.y < -30
    end
    # args.outputs[:buffer].primitives << room_rect.merge(Color::WHITE).merge({primitive_marker: :border})
  end

  def render(args)
    # output = [    ]

    if @projectile_obj
      args.outputs[:buffer].primitives << @projectile_obj
    end
  end

  def projectile
    @projectile_obj
  end

  def move(direction)
    case direction
    when :north
      @position.y += 1
    when :south
      @position.y -= 1
    when :east
      @position.x -= 1
    when :west
      @position.x += 1
    end
  end

  def shoot_projectile(args)
    start_position = {x: @position.x, y: @position.y}
    case direction
    when :north

    when :south
    when :east
    when :west
    end
  end

  def source_x
    case @direction
    when :south, :north
      0 + (@walk_frame * 32)
    when :east, :west
      64 + (@walk_frame * 32)
    end
  end
  def source_y
    0
  end
  def source_w
    32 
  end
  def source_h
    32
  end

  def to_h
    {x: @position.x, y: @position.y, w: @size.w, h: @size.h, source_x: source_x, source_y: source_y, source_w: source_w, source_h: source_h, path: @path, primitive_marker: :sprite}
  end
end